<?php

/*
Plugin Name: OPAY - Woocommerce
Description: This Woocommerce plugin integrates different payment methods supplied by OPAY Payment Gateway
Version: 1.5.15
Author: OPAY
Author URI: http://opay.lt
*/

define('OPAY_CLASS_NAME', 'WC_OPAY_Gateway');

/**
 * emisija.lt - Create WP CRON (Refunded Orders status checker) on plugin activation
 */
register_activation_hook(__FILE__, 'em_install_order_refuned_status_checker');

function em_install_order_refuned_status_checker()
{
    if (!wp_next_scheduled('em_opay_refunded_order_status_checker')) {
        wp_schedule_event(time(), 'every_minute', 'em_opay_refunded_order_status_checker');
    }
}

add_action('plugins_loaded', 'woocommerce_opay_gateway_init', 0);

function woocommerce_opay_gateway_init()
{
    load_plugin_textdomain('opay-woocommerce', false, dirname(plugin_basename(__FILE__)) . DIRECTORY_SEPARATOR . 'languages');

    // If WC_Payment_Gateway class doesn't exist, then WooCommerce is not installed on the site.
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    require_once (dirname(__FILE__) . DIRECTORY_SEPARATOR . strtolower(OPAY_CLASS_NAME) . '.class.php');

    // Adding OPAY Gateway to payment gateways
    add_filter('woocommerce_payment_gateways', 'woocommerce_add_opay_gateway');

    function woocommerce_add_opay_gateway($methods)
    {
        $methods[] = strtolower(OPAY_CLASS_NAME);
        return $methods;
    }
}


/**
 * Declare compatibility with cart_checkout_blocks feature 
 */
add_action('before_woocommerce_init', 'em_declare_cart_checkout_blocks_compatibility');
function em_declare_cart_checkout_blocks_compatibility()
{
    // Check if the required class exists
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        // Declare compatibility for 'cart_checkout_blocks'
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
    }
}

/**
 * Register payment method in woocoommerce blocks
 */

add_action('woocommerce_blocks_loaded', 'em_register_order_approval_payment_method_type');
function em_register_order_approval_payment_method_type()
{
    // Check if the required class exists
    if (!class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
        return;
    }

    // Include the Opay Blocks Checkout class
    require_once plugin_dir_path(__FILE__) . 'blocks/class-block.php';

    // Hook the registration function to the 'woocommerce_blocks_payment_method_type_registration' action
    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
            // Register an instance of WC_OPAY_Gateway_Blocks
            $payment_method_registry->register(new WC_OPAY_Gateway_Blocks);
        }
    );
}

//Disable WooCommerce function to change Order status to refunded
add_filter('woocommerce_order_fully_refunded_status', 'em_override_woocommerce_refunded_status', 3, 9999 );
function em_override_woocommerce_refunded_status($status, $order_id, $refund_id)
{
    $order = new WC_Order($order_id);

    $opay_payment_token = $order->get_meta('opay_payment_token', true);

    if(!empty($opay_payment_token) && $status == 'refunded') {
        return false;
    }
}

function ensure_tooltip_enqueue_scripts() {
    $screen = get_current_screen();
    if ( isset( $screen->id ) && $screen->id === 'woocommerce_page_wc-settings' ) {
        wp_enqueue_script( 'wc-admin-settings' ); // WooCommerce settings script (includes tooltips)
    }
}
add_action( 'admin_enqueue_scripts', 'ensure_tooltip_enqueue_scripts' );

function opay_update_settings_on_update()
{
    // Get the current Opay settings from the database
    $opay_settings = get_option('woocommerce_opay_settings', array());

    // Check if 'enabled_opay_everywhere' is NOT present in the settings
    if (!isset($opay_settings['enabled_opay_everywhere'])) {
        // Add 'enabled_opay_everywhere' and set its value to 'yes'
        $opay_settings['enabled_opay_everywhere'] = 'yes';

        // Update the settings in the database
        update_option('woocommerce_opay_settings', $opay_settings);
    }
    // Check if 'use_remote_website_settings' is NOT present in the settings
    if (!isset($opay_settings['use_remote_website_settings'])) {
        // Add 'enabled_opay_everywhere' and set its value to 'yes'
        $opay_settings['use_remote_website_settings'] = 'yes';

        // Update the settings in the database
        update_option('woocommerce_opay_settings', $opay_settings);
    }
}

add_action('admin_init', 'opay_update_settings_on_update');
