/***
 * React scripts
 */

const settings = window.wc.wcSettings.getSetting('opay_data', {});
const label = window.wp.htmlEntities.decodeEntities(settings.title) || window.wp.i18n.__('Apmokėkite populiariausiais mokėjimo būdais', 'woo-custom-payment-method-for-woo-blocks');

const Content = (props) => {
    const { eventRegistration, emitResponse } = props;
    const { onPaymentSetup } = eventRegistration;
    React.useEffect(() => {
        const unsubscribe = onPaymentSetup(async () => {
            const selected_channel = jQuery('#opay_selected_channel').val();
            if (settings.in_external_opay_page == false) {
                if (selected_channel) {
                    return {
                        type: emitResponse.responseTypes.SUCCESS,
                        meta: {
                            paymentMethodData: {
                                selected_channel,
                            },
                        },
                    };
                }

                return {
                    type: emitResponse.responseTypes.ERROR,
                    message: window.wp.i18n.__('Please choose payment method', 'opay-woocommerce'),
                };
            } else {
                const selected_channel = 'no-channel';

                return {
                    type: emitResponse.responseTypes.SUCCESS,
                    meta: {
                        paymentMethodData: {
                            selected_channel,
                        },
                    },
                };
            }

        });
        return () => {
            unsubscribe();
        };
    }, [
        emitResponse.responseTypes.ERROR,
        emitResponse.responseTypes.SUCCESS,
        onPaymentSetup
    ]);
    /* Content */
    var description = React.createElement('p', null, window.wp.htmlEntities.decodeEntities(settings.description || ''));

    var opay_selected_channel = React.createElement('input', {
        type: 'hidden',
        name: 'opay_selected_channel',
        id: 'opay_selected_channel',
        required: false,
    });

    var opay_available_payments_list = React.createElement('div', {
        id: 'opay-available-payments-list',
    });

    return React.createElement('div', null, description, opay_selected_channel, opay_available_payments_list);
};

const Opay_Block_Gateway = {
    name: 'opay',
    label: label,
    content: React.createElement(Content, null),
    edit: React.createElement(Content, null),
    icons: null,
    canMakePayment: () => true,
    ariaLabel: label,
    supports: {
        features: settings.supports,
    },
};

window.wc.wcBlocksRegistry.registerPaymentMethod(Opay_Block_Gateway);

/***
 * jQuery scripts
 */

jQuery(document).ready(function () {
    // Wait until element is cloned - loop until elements exist
    var clonePaymentMethods = function () {
        var templateElement = jQuery('#payment-opay-methods-list');
        var containerElement = jQuery('#opay-available-payments-list');

        if (templateElement.length > 0 && containerElement.length > 0) {
            var content_elements = templateElement.clone();
            containerElement.html(content_elements);
            containerElement.find('#payment-opay-methods-list').css('display', 'block');
            return true;
        }
        return false;
    };

    // Loop until elements are cloned successfully
    var checkAndClone = function () {
        if (!clonePaymentMethods()) {
            requestAnimationFrame(checkAndClone);
        }
    };

    // Handle payment method item clicks
    jQuery(document).on('click', '.opay-payment-item', function () {
        var selected_channel = jQuery(this).find('input[name="channel"]');
        jQuery('#opay_selected_channel').val(selected_channel.val());

        jQuery('.opay-payment-item').removeClass('selected-opay-payment-method');
        jQuery(this).addClass('selected-opay-payment-method');

        selected_channel.prop('checked', true);
    });

    // Handle radio button changes
    jQuery(document).on('change', 'input[name="channel"]', function () {
        var selected_channel = jQuery(this).val();
        jQuery('#opay_selected_channel').val(selected_channel);

        jQuery('.opay-payment-item').removeClass('selected-opay-payment-method');
        jQuery(this).closest('.opay-payment-item').addClass('selected-opay-payment-method');
    });

    // Attach click handler to payment method labels
    jQuery(document).on('click', 'label.wc-block-components-radio-control__option', function () {
        checkAndClone();
    });

    // Initial check when page loads
    checkAndClone();
});
