<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_OPAY_Gateway_Blocks extends AbstractPaymentMethodType
{
    private $gateway;

    protected $name = 'opay'; // your payment gateway name

    //Set options
    public function initialize()
    {
        //Get Opay payment options
        $this->settings = get_option('woocommerce_opay_settings', []);
        $this->gateway = new WC_OPAY_Gateway();

    }

    //Check if payment gateway is active
    public function is_active()
    {
        return $this->gateway->is_available();
    }

    //Register payment scripts
    public function get_payment_method_script_handles()
    {
        // Only register the script if it's the frontend, and we're on the checkout/cart page or opay is enabled everywhere
        if (
            !is_admin() && // Ensure it's not the admin area
            (
                $this->gateway->enabled_opay_everywhere === 'yes' ||
                is_checkout() ||
                is_cart() ||
                is_page('checkout') ||
                is_page('cart') ||
                is_wc_endpoint_url('checkout') ||
                is_wc_endpoint_url('cart')
            )
        ) {
            wp_register_script(
                'opay-blocks-integration',
                plugin_dir_url(__FILE__) . '../js/opay-checkout-blocks.js',
                [
                    'wc-blocks-registry',
                    'wc-settings',
                    'wp-element',
                    'wp-html-entities',
                    'wp-i18n',
                ],
                null,
                true
            );

            // Enqueue the script to ensure it loads
            wp_enqueue_script('opay-blocks-integration');

            // Set up script translations
            if (function_exists('wp_set_script_translations')) {
                wp_set_script_translations('opay-blocks-integration');
            }

            return ['opay-blocks-integration'];
        }

        // If not eligible, don't load the script
        return [];
    }

    //Get payment information for checkout
    public function get_payment_method_data()
    {
        //Check if wc blocks enabled
        if ($this->gateway->enabled_wc_blocks == 'yes' && is_checkout()) {
            if ($this->gateway->show_payment_methods == 'in_external_opay_page') {
                return [
                    'title' => $this->gateway->title,
                    'content' => '',
                    'description' => __('Apmokėkite populiariausiais mokėjimo būdais', 'woo-custom-payment-method-for-woo-blocks'),
                    'in_external_opay_page' => true,
                ];
            } else {
                return [
                    'title' => $this->gateway->title,
                    'content' => $this->gateway->payment_fields(),
                    'description' => __('Apmokėkite populiariausiais mokėjimo būdais', 'woo-custom-payment-method-for-woo-blocks'),
                    'in_external_opay_page' => false,
                ];
            }
        }
    }
}
