<?php

if (is_file(DIR_SYSTEM.'library/opay/opay_8.1.gateway.inc.php')) {
    require_once DIR_SYSTEM.'library/opay/opay_8.1.gateway.inc.php';
} else {
    require_once DIR_SYSTEM.'library/vendor/opay/opay_8.1.gateway.inc.php';
}

class ControllerExtensionPaymentOpay extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->model('setting/store');

        $totalStores = $this->model_setting_store->getTotalStores();
        $storeId = isset($this->request->get['store_id']) ? $this->request->get['store_id'] : 0;

        if ($totalStores > 0) {
            $data['stores_info'] = array(
                // Default store
                0 => array(
                    'store_id' => 0,
                    'name' => $this->config->get('config_name').' (Default)'
                )
            );
            $data['stores_info'] = array_merge($data['stores_info'], $this->model_setting_store->getStores());
            $data['stores_info'][$storeId]['selected'] = true;
        }
        $data['store_change_url'] = $this->url->link('extension/payment/opay', 'user_token=' . $this->session->data['user_token'].'&store_id=', true);
        $data['selected_store'] = $storeId;


        if ($storeId != 0 && $totalStores > 0) {
            $this->loadStoreSettings($storeId);
        }

        $this->load->language('extension/payment/opay');
        $this->load->model('setting/setting');
        $this->document->setTitle($this->language->get('heading_title'));
        

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {

            // Trim data
            $requestData = $this->request->post;
            $requestData['opay_website_id'] = trim($requestData['opay_website_id']);
            $requestData['opay_user_id'] = trim($requestData['opay_user_id']);
            $requestData['opay_password_sign'] = trim($requestData['opay_password_sign']);
            
            foreach ($requestData as $key => $val) {
                $requestData['payment_'.$key] = $val;
                unset($requestData[$key]);    
            }
            
            $this->model_setting_setting->editSetting('payment_opay', $requestData, $storeId);
            
            $this->session->data['success'] = $this->language->get('text_success');

            $redirectParams = 'user_token='.$this->session->data['user_token'];

            if ($totalStores > 0) {
                $this->response->redirect($this->url->link('extension/payment/opay', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $storeId, true));
                exit();
            }

            $this->response->redirect($this->url->link('marketplace/extension', $redirectParams.'&type=payment', true));
            exit();
        }

        $data['heading_title']                      = $this->language->get('heading_title');
        $data['panel_change_settings']              = $this->language->get('panel_change_settings');
        $data['block_main_settings']                = $this->language->get('block_main_settings');
        $data['block_appearance_settings']          = $this->language->get('block_appearance_settings');
        $data['block_additional_settings']          = $this->language->get('block_additional_settings');

        $data['text_yes']                           = $this->language->get('text_yes');
        $data['text_no']                            = $this->language->get('text_no');
        $data['text_all_zones']                     = $this->language->get('text_all_zones');
        $data['text_enabled']                       = $this->language->get('text_enabled');
        $data['text_disabled']                      = $this->language->get('text_disabled');

        $data['entry_website']                      = $this->language->get('entry_website');
        $data['entry_status']                       = $this->language->get('entry_status');
        $data['entry_finished_order_status']        = $this->language->get('entry_finished_order_status');
        $data['entry_new_order_status']             = $this->language->get('entry_new_order_status');
        $data['entry_convert_order_currency']       = $this->language->get('entry_convert_order_currency');
        $data['entry_convert_order_currency_desc']  = $this->language->get('entry_convert_order_currency_desc');
        $data['entry_canceled_order_status']        = $this->language->get('entry_canceled_order_status');
        $data['entry_user_id']                      = $this->language->get('entry_user_id');
        $data['entry_user_id_descritpion']          = $this->language->get('entry_user_id_descritpion');
        $data['entry_test_mode']                    = $this->language->get('entry_test_mode');
        $data['entry_geo_zone']                     = $this->language->get('entry_geo_zone');
        $data['entry_password_signature']           = $this->language->get('entry_password_signature');
        $data['entry_rsa_signature']                = $this->language->get('entry_rsa_signature');
        $data['entry_certificate']                  = $this->language->get('entry_certificate');
        $data['entry_show_channels']                = $this->language->get('entry_show_channels');
        $data['entry_sort_order']                   = $this->language->get('entry_sort_order');
        $data['entry_payment_icon_height']          = $this->language->get('entry_payment_icon_height');
        $data['entry_signature_type']               = $this->language->get('entry_signature_type');
        $data['entry_sign_with_rsa_private_key']    = $this->language->get('entry_sign_with_rsa_private_key');
        $data['entry_sign_with_signature_password'] = $this->language->get('entry_sign_with_signature_password');
        $data['entry_in_checkout_page']             = $this->language->get('entry_in_checkout_page');
        $data['entry_in_checkout_page_grouped']     = $this->language->get('entry_in_checkout_page_grouped');
        $data['entry_in_opay_page']                 = $this->language->get('entry_in_opay_page');
        $data['entry_store_id']                     = $this->language->get('entry_store_id');
        $data['entry_store_id_desc']                = $this->language->get('entry_store_id_desc');
        $data['warn_unsaved_changes']               = $this->language->get('warn_unsaved_changes');

        $data['button_save']   = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        $data['error_warning']            = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_opay_website_id']    = isset($this->error['opay_website_id']) ? $this->error['opay_website_id'] : '';
        $data['error_opay_password_sign'] = isset($this->error['opay_password_sign']) ? $this->error['opay_password_sign'] : '';
        $data['error_opay_certificate']   = isset($this->error['opay_certificate']) ? $this->error['opay_certificate'] : '';
        $data['error_opay_rsa_signature'] = isset($this->error['opay_rsa_signature']) ? $this->error['opay_rsa_signature']  : '';
        $data['error_opay_user_id']       = isset($this->error['opay_user_id']) ? $this->error['opay_user_id'] : '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/opay', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['payment_channel_icon_heights_array'] = array('33', '49');

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'].'&type=payment', true);
        
        $data['action'] = $this->url->link('extension/payment/opay', 'user_token=' . $this->session->data['user_token'].'&store_id='.$storeId, true);
        
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['convert_order_currency_options'] = $this->getCurrenciesToConvert();
        
        $this->load->model('localisation/geo_zone');
        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        $newOrderIdDefault      = $this->getOpayConfig('opay_new_order_id') ? $this->getOpayConfig('opay_new_order_id') : 1;
        $canceledOrderIdDefault = $this->getOpayConfig('opay_canceled_order_id') ? $this->getOpayConfig('opay_canceled_order_id') : 7;
        $finishedOrderIdDefault = $this->getOpayConfig('opay_finished_order_id') ? $this->getOpayConfig('opay_finished_order_id') : 15;
        $failedOrderIrdDefault  = $this->getOpayConfig('opay_failed_order_id') ? $this->getOpayConfig('opay_failed_order_id') : 10;

        $data['opay_status']                      = isset($this->request->post['opay_status']) ? $this->request->post['opay_status'] : $this->getOpayConfig('opay_status');
        $data['opay_website_id']                  = isset($this->request->post['opay_website_id']) ? $this->request->post['opay_website_id'] : $this->getOpayConfig('opay_website_id');
        $data['opay_user_id']                     = isset($this->request->post['opay_user_id']) ? $this->request->post['opay_user_id'] : $this->getOpayConfig('opay_user_id');
        $data['opay_signature_type']              = isset($this->request->post['opay_signature_type']) ? $this->request->post['opay_signature_type'] : $this->getOpayConfig('opay_signature_type');
        $data['opay_test_mode']                   = isset($this->request->post['opay_test_mode']) ? $this->request->post['opay_test_mode'] : $this->getOpayConfig('opay_test_mode');
        $data['opay_password_sign']               = isset($this->request->post['opay_password_sign']) ? $this->request->post['opay_password_sign'] : $this->getOpayConfig('opay_password_sign');
        $data['opay_rsa_signature']               = isset($this->request->post['opay_rsa_signature']) ? $this->request->post['opay_rsa_signature'] : $this->getOpayConfig('opay_rsa_signature');
        $data['opay_certificate']                 = isset($this->request->post['opay_certificate']) ? $this->request->post['opay_certificate'] : $this->getOpayConfig('opay_certificate');
        $data['opay_new_order_id']                = isset($this->request->post['opay_new_order_id']) ? $this->request->post['opay_new_order_id'] : $newOrderIdDefault;
        $data['opay_finished_order_id']           = isset($this->request->post['opay_finished_order_id']) ? $this->request->post['opay_finished_order_id'] : $finishedOrderIdDefault;
        $data['opay_canceled_order_id']           = isset($this->request->post['opay_canceled_order_id']) ? $this->request->post['opay_canceled_order_id'] : $canceledOrderIdDefault;
        $data['opay_failed_order_id']             = isset($this->request->post['opay_failed_order_id']) ? $this->request->post['opay_failed_order_id'] : $failedOrderIrdDefault;
        $data['opay_convert_order_currency_code'] = isset($this->request->post['opay_convert_order_currency_code']) ? $this->request->post['opay_convert_order_currency_code'] : $this->getOpayConfig('opay_convert_order_currency_code');
        $data['opay_show_channels']               = isset($this->request->post['opay_show_channels']) ? $this->request->post['opay_show_channels'] : $this->getOpayConfig('opay_show_channels');
        $data['opay_geo_zone_id']                 = isset($this->request->post['opay_geo_zone_id']) ? $this->request->post['opay_geo_zone_id'] : $this->getOpayConfig('opay_geo_zone_id');
        $data['opay_sort_order']                  = isset($this->request->post['opay_sort_order']) ? $this->request->post['opay_sort_order'] : $this->getOpayConfig('opay_sort_order');
        $data['opay_payment_channel_icon_height'] = isset($this->request->post['opay_payment_channel_icon_height']) ? $this->request->post['opay_payment_channel_icon_height'] : $this->getOpayConfig('opay_payment_channel_icon_height');

        $this->template = 'extension/payment/opay';

        $data['header']      = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer']      = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view($this->template, $data));
    }

    public function getOpayConfig($name)
    {
        return $this->config->get('payment_'.$name);
    }
    
    
    public function install()
    {
        $this->load->model('user/user_group');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'extension/payment/opay');
        $this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'extension/payment/opay');
    }
    
    public function uninstall() 
    {
        $this->load->model('user/user_group');
        $this->model_user_user_group->removePermission($this->user->getGroupId(), 'access', 'extension/payment/opay');
        $this->model_user_user_group->removePermission($this->user->getGroupId(), 'modify', 'extension/payment/opay');   
    }

    private function getCurrenciesToConvert()
    {
        $currencyOptionsArr = array(
            array('code' => '',    'name' => $this->language->get('entry_convert_order_currency_dont')),
        ); 
        
        $this->load->model('localisation/currency');
        $allCurrArr = $this->model_localisation_currency->getCurrencies();
        foreach ($allCurrArr as $currArr)
        {
            $currencyOptionsArr[] = array('code' => $currArr['code'], 'name' => $this->language->get('entry_convert_order_currency_to').' '.$currArr['code']);        
        }
        
        return $currencyOptionsArr;   
    }
    
    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/payment/opay')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (empty($this->request->post['opay_website_id'])) {
            $this->error['opay_website_id'] = $this->language->get('error_website');
        }

        if (!empty($this->request->post['opay_signature_type']) && $this->request->post['opay_signature_type'] == 'rsa') {
            if (empty($this->request->post['opay_rsa_signature'])) {
                $this->error['opay_rsa_signature'] = $this->language->get('error_empty_rsa_signature');
            }
            if (empty($this->request->post['opay_certificate'])) {
                $this->error['opay_certificate'] = $this->language->get('error_empty_certificate');
            }
        } else {
            if (empty($this->request->post['opay_password_sign'])) {
                $this->error['opay_password_sign'] = $this->language->get('error_empty_signing');
            }
        }

        if ($this->request->post['opay_status'] && empty($this->request->post['opay_status'])) {
            $this->error['opay_user_id'] = $this->language->get('error_empty_user_id');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    private function loadStoreSettings($storeId = 0)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '$storeId'");
        foreach ($query->rows as $setting) {
            if (!$setting['serialized']) {
                $this->config->set($setting['key'], $setting['value']);
            } else {
                $this->config->set($setting['key'], json_decode($setting['value'], true));
            }
        }
    }

}
