<?php

if (is_file(DIR_SYSTEM.'library/opay/opay_8.1.gateway.inc.php')) {
    require_once DIR_SYSTEM.'library/opay/opay_8.1.gateway.inc.php';
} else {
    require_once DIR_SYSTEM.'library/vendor/opay/opay_8.1.gateway.inc.php';
}

class ModelPaymentOpay extends Model
{
    public function getMethod($billingDetail)
    {
        // If extension is disabled
        if (!$this->config->get('opay_status')) {
            return array();
        }

        // If geo zone has been configured in opay settings, check if geo_zone
        // has client's country and zone in db.
        if ($opayGeoZone = $this->config->get('opay_geo_zone_id')) {
            $query = 'SELECT * FROM '.DB_PREFIX.'zone_to_geo_zone'
                .' WHERE geo_zone_id='.(int)$opayGeoZone
                .' AND country_id='.(int)$billingDetail['country_id'];
            if (isset($billingDetail['zone_id'])) {
                $query .= ' AND (zone_id='.(int)$billingDetail['zone_id'].' OR zone_id=0)';
            }

            $query = $this->db->query($query);
            if (!$query->num_rows) {
                return array();
            }
        }

        $paymentGatewayName = $this->getSettings('payment_gateway_name');
        if (!empty($paymentGatewayName)) {
            $title = $paymentGatewayName;
        } else {
            if (version_compare(VERSION, '2.3', '>=')) {
                $this->load->language('extension/payment/opay');
            } else {
                $this->load->language('payment/opay');
            }
            $title = $this->language->get('text_title');
        }

        $method_data = array(
            'code'       => 'opay',
            'title'      => $title,
            'text'       => '',
            'sort_order' => $this->config->get('opay_sort_order'),
            'terms'      => ''
        );

        return $method_data;
    }


    public function getSettings($name = '')
    {
        if (empty($this->getSettingsArray))
        {
            if (!empty($this->session->data['payment_address']['iso_code_2'])) {
                $countryIso = $this->session->data['payment_address']['iso_code_2'];
            } elseif (!empty($this->session->data['payment_country_id'])) {
                // For OC v1.5.6.1
                $countryId = $this->session->data['payment_country_id'];
                $this->load->model('localisation/country');
                $country = $this->model_localisation_country->getCountry($countryId);
                $countryIso = $country['iso_code_2'];
            }

            if (!empty($countryIso)) {
                $signatureType = $this->config->get('opay_signature_type');

                $opay = new OpayGateway;

                if ($signatureType == 'rsa')
                {
                    $opay->setMerchantRsaPrivateKey($this->config->get('opay_rsa_signature'));
                    $opay->setOpayCertificate($this->config->get('opay_certificate'));
                }
                else
                {
                    $opay->setSignaturePassword($this->config->get('opay_password_sign'));
                }

                $paramsArray = array(
                    'service_name' => 'getSettings',
                    'website_id'   => $this->config->get('opay_website_id'),
                    'language'     => $this->language->get('code'),
                    'country'      => $countryIso
                );

                try
                {
                    $paramsArray = $opay->signArrayOfParameters($paramsArray);
                    $array = $opay->webServiceRequest('https://gateway.opay.lt/api/websites/', $paramsArray);
                }
                catch (OpayGatewayException $e)
                {
                    $array = array();
                }

                if (!empty($array['response']['result']))
                {
                    $this->getSettingsArray = $array['response']['result'];
                }
            }
        }

        if ($name != '')
        {
            return (isset($this->getSettingsArray[$name])) ? $this->getSettingsArray[$name] : '';
        }
        else
        {
            return (!empty($this->getSettingsArray)) ? $this->getSettingsArray : array();
        }


    }

    public function getDbEngine()
    {
        $query = $this->db->query("SELECT ENGINE FROM information_schema.TABLES WHERE TABLE_NAME = '" . DB_PREFIX . "order' AND TABLE_SCHEMA = '" . DB_DATABASE . "'");
        if ($query->num_rows) {
            return $query->row['ENGINE'];
        }

        return '';
    }

    public function getOrderStatusIdAndLock($orderId)
    {
        $query = $this->db->query("SELECT `order_status_id` FROM `" . DB_PREFIX . "order` WHERE `order_id` = '" . (int)$orderId . "' FOR UPDATE");
        if ($query->num_rows) {
            return $query->row['order_status_id'];
        }

        return 0;
    }
}
