<?php
//////////////////////////////////////////////////////
// If OpenCart version is less than 2
//////////////////////////////////////////////////////

if(version_compare(VERSION, '2', "<")):
?>

<?php echo $header; ?>

<div id="content">
<div class="breadcrumb">
<?php foreach ($breadcrumbs as $breadcrumb) { ?>
<?php echo $breadcrumb['separator']; ?><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a>
<?php } ?>
</div>
<?php if ($error_warning) { ?>
<div class="warning"><?php echo $error_warning; ?></div>
<?php } ?>
<div class="box">
<div class="heading">
<h1><img src="view/image/payment.png" alt="" /> <?php echo $heading_title; ?></h1>
<div class="buttons"><a onclick="jQuery('#form').submit();" class="button btn btn-success"><?php echo $button_save; ?></a><a href="<?php echo $cancel; ?>" class="button btn btn-danger"><?php echo $button_cancel; ?></a></div>
</div>
<div class="content">

<?php if (!empty($stores_info)): ?>
<form>
<table class="form">
<tr>
<td>
  <strong><?php echo $entry_store_id; ?></strong><br>
  <span class="help"><?php echo $entry_store_id_desc; ?></span>
</td>
<td>
<select name="store_id" id="store_id">
<?php foreach($stores_info as $store): ?>
<option value="<?php echo $store['store_id']; ?>" <?php echo !empty($store['selected']) ? ' selected="selected"' : ''; ?>><?php echo $store['name']; ?></option>
<?php endforeach; ?>
</select>
</td>
</tr>
</table>
</form>
<?php endif; ?>

<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form">
<div id="tab-general" class="page">
<table class="form">

<tr>
<td colspan="2"><h3><?php echo $block_main_settings;?></h3></td>
</tr>

<tr>
<td><span class="required">*</span> <strong><?php echo $entry_website; ?></strong></td>
<td>
<input type="text" name="opay_website_id" value="<?php echo $opay_website_id; ?>" size="" /> <br>
<?php if ($error_opay_website_id): ?>
<span class="error"><?php echo $error_opay_website_id; ?></span>
<?php endif; ?>
</td>
</tr>
<tr class="test_mode_row">
<td <?php if ($opay_test_mode): ?>style="border-bottom:0;"<?php endif; ?> ><strong><?php echo $entry_test_mode; ?></strong></td>
<td <?php if ($opay_test_mode): ?>style="border-bottom:0;"<?php endif; ?> >
<select name="opay_test_mode" id="opay_test_mode">
<?php if ($opay_test_mode): ?>
<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
<option value="0"><?php echo $text_disabled; ?></option>
<?php else: ?>
<option value="1"><?php echo $text_enabled; ?></option>
<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
<?php endif; ?>
</select>
</td>
</tr>




<tr class="testing_row" <?php if (!(bool)$opay_test_mode): ?>style="display:none;"<?php endif; ?>>
<td><span class="required">*</span> <?php echo $entry_user_id; ?><br/><span class="help"><?php echo $entry_user_id_descritpion; ?></span></td>
<td>
<input type="text" name="opay_user_id" value="<?php echo $opay_user_id; ?>" size="" />
<?php if ($error_opay_user_id): ?>
<span class="error"><?php echo $error_opay_user_id; ?></span>
<?php endif; ?>
</td>
</tr>


<tr>
<td style="border-bottom:0;"><strong><?php echo $entry_signature_type; ?></strong></td>
<td style="border-bottom:0;">
<select name="opay_signature_type" id="opay_signature_type">
<?php if ($opay_signature_type == 'password') : ?>
<?php $opaySignatureType = 'password'; ?>
<option value="rsa"><?php echo $entry_sign_with_rsa_private_key; ?></option>
<option value="password" selected="selected"><?php echo $entry_sign_with_signature_password; ?></option>
<?php else : ?>
<?php $opaySignatureType = 'rsa'; ?>
<option value="rsa" selected="selected"><?php echo $entry_sign_with_rsa_private_key; ?></option>
<option value="password"><?php echo $entry_sign_with_signature_password; ?></option>
<?php endif; ?>
</select>

</td>
</tr>

<tr class="password_row" <?php if ($opaySignatureType != 'password'): ?>style="display:none"<?php endif; ?> >
<td><span class="required">*</span> <?php echo $entry_password_signature; ?></td>
<td>
<input type="text" name="opay_password_sign" value="<?php echo $opay_password_sign; ?>" size="38" />
<?php if ($error_opay_password_sign): ?>
<span class="error"><?php echo $error_opay_password_sign; ?></span>
<?php endif; ?>

</td>
</tr>

<tr class="rsa_row" <?php if ($opaySignatureType != 'rsa'): ?>style="display:none"<?php endif; ?> >
<td style="border-bottom:0;"><span class="required">*</span> <?php echo $entry_rsa_signature; ?></td>
<td style="border-bottom:0;">
<textarea name="opay_rsa_signature" id="" cols="120" rows="10"><?php echo $opay_rsa_signature; ?></textarea>
<?php if ($error_opay_rsa_signature): ?>
<span class="error"><?php echo $error_opay_rsa_signature; ?></span>
<?php endif; ?>

</td>
</tr>

<tr class="rsa_row" <?php if ($opaySignatureType != 'rsa'): ?>style="display:none"<?php endif; ?> >
<td><span class="required">*</span> <?php echo $entry_certificate; ?></td>
<td>
<textarea name="opay_certificate" id="" cols="120" rows="10"><?php echo $opay_certificate; ?></textarea>
<?php if ($error_opay_certificate): ?>
<span class="error"><?php echo $error_opay_certificate; ?></span>
<?php endif; ?>
</td>
</tr>

<tr>
<td width=""><?php echo $entry_show_channels; ?></td>
<td>
<select name="opay_show_channels">
<option value="2" <?php echo 2 == $opay_show_channels ? 'selected="selected"' : ''; ?>><?php echo $entry_in_checkout_page; ?></option>
<option value="1" <?php echo 1 == $opay_show_channels ? 'selected="selected"' : ''; ?>><?php echo $entry_in_checkout_page_grouped; ?></option>
<option value="0" <?php echo 0 == $opay_show_channels ? 'selected="selected"' : ''; ?>><?php echo $entry_in_opay_page; ?></option>
</select>
</td>
</tr>

<tr>
<td colspan="2"><h3><?php echo $block_appearance_settings; ?></h3></td>
</tr>

<tr>
<td><?php echo $entry_payment_icon_height; ?></td>
<td>
<select name="opay_payment_channel_icon_height">
<?php foreach ($payment_channel_icon_heights_array as $icon_heigh): ?>
<?php if ($icon_heigh == $opay_payment_channel_icon_height): ?>
<option value="<?php echo $icon_heigh; ?>" selected="selected"><?php echo $icon_heigh.' px'; ?></option>
<?php else: ?>
<option value="<?php echo $icon_heigh; ?>"><?php echo $icon_heigh.' px'; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>
</td>
</tr>


<tr>
<td colspan="2"><h3><?php echo $block_additional_settings;?></h3></td>
</tr>


<tr>
<td><?php echo $entry_convert_order_currency; ?><br/><span class="help"><?php echo $entry_convert_order_currency_desc; ?></span></td>
<td>
<select name="opay_convert_order_currency_code">
<?php foreach ($convert_order_currency_options as $convert_currency_option): ?>
<?php if ($convert_currency_option['code'] == $opay_convert_order_currency_code): ?>
<option value="<?php echo $convert_currency_option['code']; ?>" selected="selected"><?php echo $convert_currency_option['name']; ?></option>
<?php else: ?>
<option value="<?php echo $convert_currency_option['code']; ?>"><?php echo $convert_currency_option['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>
</td>
</tr>



<tr>
<td><?php echo $entry_new_order_status; ?></td>
<td>
<select name="opay_new_order_id">
<?php foreach ($order_statuses as $order_status): ?>
<?php if ($order_status['order_status_id'] == $opay_new_order_id): ?>
<option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
<?php else: ?>
<option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>
</td>
</tr>

<tr>
<td><?php echo $entry_finished_order_status; ?></td>
<td>
<select name="opay_finished_order_id">
<?php foreach ($order_statuses as $order_status): ?>
<?php if ($order_status['order_status_id'] == $opay_finished_order_id): ?>
<option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
<?php else: ?>
<option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>
</td>
</tr>

<tr>
<td><?php echo $entry_canceled_order_status; ?></td>
<td>
<select name="opay_canceled_order_id">
<?php foreach ($order_statuses as $order_status): ?>
<?php if ($order_status['order_status_id'] == $opay_canceled_order_id): ?>
<option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
<?php else: ?>
<option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>
</td>
</tr>


<tr>
<td><?php echo $entry_geo_zone; ?></td>
<td>
<select name="opay_geo_zone_id">
<option value="0"><?php echo $text_all_zones; ?></option>
<?php foreach ($geo_zones as $geo_zone): ?>
<?php if ($geo_zone['geo_zone_id'] == $opay_geo_zone_id): ?>
<option value="<?php echo $geo_zone['geo_zone_id']; ?>" selected="selected"><?php echo $geo_zone['name']; ?></option>
<?php else: ?>
<option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>
</td>
</tr>
<tr>
<td width=""><?php echo $entry_status; ?></td>
<td>
<select name="opay_status">
<?php if (isset($opay_status) && $opay_status == false): ?>
<option value="1"><?php echo $text_enabled; ?></option>
<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
<?php else: ?>
<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
<option value="0"><?php echo $text_disabled; ?></option>
<?php endif; ?>
</select>
</td>
</tr>
<tr>
<td><?php echo $entry_sort_order; ?></td>
<td>
<input type="text" name="opay_sort_order"value="<?php echo $opay_sort_order; ?>" size="1" />
</td>
</tr>

</table>
</div>
</form>
</div>
</div>
</div>


<script type="text/javascript">
jQuery(function($) {

    var previousStoreId
      , formChanged;

    var handleTestMode = function() {
        if ($('option:selected', this).val() == '1') {
            $('.testing_row').show();
            $('.test_mode_row td').css("border-bottom", "0");
            $('.testing_row').css("border-bottom", "1px dotted #cccccc");
        } else {
            $('.testing_row').hide();
            $('.test_mode_row td').css("border-bottom", "1px dotted #cccccc");
            $('.testing_row').css("border-bottom", "0");
        }
    }

    var handleFormChange = function() {
        formChanged = true;
    };

    var handleStoreIdFocus = function() {
        previousStoreId = $(this).val();
    };

    var handleStoreId = function() {
        var storeId     = $(this).val()
          , redirectUrl = updateQueryStringParameter(window.location.href, 'store_id', storeId);

        if (formChanged && !confirm("<?php echo $warn_unsaved_changes; ?>")) {
          $(this).val(previousStoreId);
          return;
        }
        window.location = redirectUrl;
    }

    var handleOpaySignatureType = function() {
        if ($('option:selected', this).val() == 'rsa') {
            $('.password_row').hide();
            $('.rsa_row').show();
        } else if ($('option:selected', this).val() == 'password') {
            $('.rsa_row').hide();
            $('.password_row').show();
        }
    };

    function updateQueryStringParameter(uri, key, value) {
        var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
        var separator = uri.indexOf('?') !== -1 ? "&" : "?";
        if (uri.match(re)) {
            return uri.replace(re, '$1' + key + "=" + value + '$2');
        }
        else {
            return uri + separator + key + "=" + value;
        }
    }

    // Attach handlers
    $('#opay_test_mode').change(handleTestMode);
    $('#opay_signature_type').change(handleOpaySignatureType);
    $('#store_id').on('focus', handleStoreIdFocus).change(handleStoreId);
    $('#form').change(handleFormChange);
});
</script>
<?php echo $footer; ?>



<?php
//////////////////////////////////////////////////////
// if greater or equal to version 2
//////////////////////////////////////////////////////

else:
?>

<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
<div class="page-header">
<div class="container-fluid">
<div class="pull-right">
<button type="submit" form="form" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
<a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
<h1><?php echo $heading_title; ?></h1>
<ul class="breadcrumb">
<?php foreach ($breadcrumbs as $breadcrumb) { ?>
<li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
<?php } ?>
</ul>
</div>
</div>
<div class="container-fluid">




<?php if ($error_warning) { ?>
<div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
<button type="button" class="close" data-dismiss="alert">&times;</button>
</div>
<?php } ?>

<?php if (!empty($stores_info)): ?>
<div class="panel panel-default">
<div class="panel-body">
<form class="form-horizontal">
<fieldset>
<div class="form-group">
<label class="col-sm-2 control-label" for="store_id"><span title="" data-toggle="tooltip" data-original-title="<?php echo $entry_store_id_desc; ?>"><?php echo $entry_store_id; ?></span></label>
<div class="col-sm-10">
<select name="store_id" id="store_id" class="form-control">
<?php foreach($stores_info as $store): ?>
<option value="<?php echo $store['store_id']; ?>" <?php echo !empty($store['selected']) ? ' selected="selected"' : ''; ?>><?php echo $store['name']; ?></option>
<?php endforeach; ?>
</select>
</div>
</div>
</fieldset>
</form>
</div>
</div>
<?php endif; ?>

<div class="panel panel-default">
<div class="panel-body">
<form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form" class="form-horizontal">


<fieldset>
<legend><?php echo $block_main_settings; ?></legend>

<div class="form-group required">
<label class="col-sm-2 control-label" for="input-website-id"><?php echo $entry_website; ?></label>
<div class="col-sm-10">
<input type="text" name="opay_website_id" value="<?php echo $opay_website_id; ?>" placeholder="<?php echo $entry_website; ?>" id="input-website-id" class="form-control" />
<?php if ($error_opay_website_id): ?>
<div class="text-danger"><?php echo $error_opay_website_id; ?></div>
<?php endif; ?>
</div>
</div>

<div class="form-group">
<label class="col-sm-2 control-label" for="opay_test_mode"><?php echo $entry_test_mode; ?></label>
<div class="col-sm-10">
<select name="opay_test_mode" id="opay_test_mode" class="form-control">
<?php if ($opay_test_mode): ?>
<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
<option value="0"><?php echo $text_disabled; ?></option>
<?php else: ?>
<option value="1"><?php echo $text_enabled; ?></option>
<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
<?php endif; ?>
</select>
</div>
</div>

<div class="form-group required testing_row" <?php if (!(bool)$opay_test_mode): ?>style="display:none;"<?php endif; ?>>
<label class="col-sm-2 control-label" for="input-user-id"><span title="" data-toggle="tooltip" data-original-title="<?php echo $entry_user_id_descritpion; ?>"><?php echo $entry_user_id; ?></span></label>
<div class="col-sm-10">
<input type="text" name="opay_user_id" value="<?php echo $opay_user_id; ?>" placeholder="<?php echo $entry_user_id; ?>" id="input-user-id" class="form-control" />
<?php if ($error_opay_user_id): ?>
<div class="text-danger"><?php echo $error_opay_user_id; ?></div>
<?php endif; ?>
</div>
</div>

<div class="form-group">
<label class="col-sm-2 control-label" for="opay_signature_type"><?php echo $entry_signature_type; ?></label>
<div class="col-sm-10">
<select name="opay_signature_type" id="opay_signature_type" class="form-control">
<?php if ($opay_signature_type == 'password') : ?>
<?php $opaySignatureType = 'password'; ?>
<option value="rsa"><?php echo $entry_sign_with_rsa_private_key; ?></option>
<option value="password" selected="selected"><?php echo $entry_sign_with_signature_password; ?></option>
<?php else : ?>
<?php $opaySignatureType = 'rsa'; ?>
<option value="rsa" selected="selected"><?php echo $entry_sign_with_rsa_private_key; ?></option>
<option value="password"><?php echo $entry_sign_with_signature_password; ?></option>
<?php endif; ?>
</select>
</div>
</div>

<div class="form-group required password_row" <?php if ($opaySignatureType != 'password'): ?>style="display:none"<?php endif; ?> >
<label class="col-sm-2 control-label" for="input-password-sign"><?php echo $entry_password_signature; ?></label>
<div class="col-sm-10">
<input type="text" name="opay_password_sign" value="<?php echo $opay_password_sign; ?>" placeholder="<?php echo $entry_password_signature; ?>" id="input-password-sign" class="form-control" />
<?php if ($error_opay_password_sign): ?>
<div class="text-danger"><?php echo $error_opay_password_sign; ?></div>
<?php endif; ?>

</div>
</div>

<div class="form-group required rsa_row" <?php if ($opaySignatureType != 'rsa'): ?>style="display:none"<?php endif; ?> >
<label class="col-sm-2 control-label" for="input-rsa-signature"><?php echo $entry_rsa_signature; ?></label>
<div class="col-sm-10">
<textarea class="form-control" id="input-rsa-signature" placeholder="<?php echo $entry_rsa_signature; ?>" rows="8" name="opay_rsa_signature"><?php echo $opay_rsa_signature; ?></textarea>
<?php if ($error_opay_rsa_signature): ?>
<div class="text-danger"><?php echo $error_opay_rsa_signature; ?></div>
<?php endif; ?>

</div>
</div>

<div class="form-group required rsa_row" <?php if ($opaySignatureType != 'rsa'): ?>style="display:none"<?php endif; ?> >
<label class="col-sm-2 control-label" for="input-certificate"><?php echo $entry_certificate; ?></label>
<div class="col-sm-10">
<textarea class="form-control" id="input-certificate" placeholder="<?php echo $entry_certificate; ?>" rows="8" name="opay_certificate"><?php echo $opay_certificate; ?></textarea>
<?php if ($error_opay_certificate): ?>
<div class="text-danger"><?php echo $error_opay_certificate; ?></div>
<?php endif; ?>
</div>
</div>

<div class="form-group">
<label class="col-sm-2 control-label" for="opay_show_channels"><?php echo $entry_show_channels; ?></label>
<div class="col-sm-10">
<select name="opay_show_channels" id="opay_show_channels" class="form-control">
<option value="2" <?php echo 2 == $opay_show_channels ? 'selected="selected"' : ''; ?>><?php echo $entry_in_checkout_page; ?></option>
<option value="1" <?php echo 1 == $opay_show_channels ? 'selected="selected"' : ''; ?>><?php echo $entry_in_checkout_page_grouped; ?></option>
<option value="0" <?php echo 0 == $opay_show_channels ? 'selected="selected"' : ''; ?>><?php echo $entry_in_opay_page; ?></option>
</select>

</div>
</div>
</fieldset>

<fieldset>
<legend><?php echo $block_appearance_settings; ?></legend>

<div class="form-group">
<label class="col-sm-2 control-label" for="opay_payment_channel_icon_height"><?php echo $entry_payment_icon_height; ?></label>
<div class="col-sm-10">
<select name="opay_payment_channel_icon_height" id="opay_payment_channel_icon_height" class="form-control">
<?php foreach ($payment_channel_icon_heights_array as $icon_heigh): ?>
<?php if ($icon_heigh == $opay_payment_channel_icon_height): ?>
<option value="<?php echo $icon_heigh; ?>" selected="selected"><?php echo $icon_heigh.' px'; ?></option>
<?php else: ?>
<option value="<?php echo $icon_heigh; ?>"><?php echo $icon_heigh.' px'; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>

</div>
</div>
</fieldset>
<fieldset>
<legend><?php echo $block_additional_settings; ?></legend>

<div class="form-group">
<label class="col-sm-2 control-label" for="store_id"><span title="" data-toggle="tooltip" data-original-title="<?php echo $entry_convert_order_currency_desc; ?>"><?php echo $entry_convert_order_currency; ?></span></label>
<div class="col-sm-10">
<select name="opay_convert_order_currency_code" id="opay_new_order_id" class="form-control">
<?php foreach ($convert_order_currency_options as $convert_currency_option): ?>
<?php if ($convert_currency_option['code'] == $opay_convert_order_currency_code): ?>
<option value="<?php echo $convert_currency_option['code']; ?>" selected="selected"><?php echo $convert_currency_option['name']; ?></option>
<?php else: ?>
<option value="<?php echo $convert_currency_option['code']; ?>"><?php echo $convert_currency_option['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>

</div>
</div>


<div class="form-group">
<label class="col-sm-2 control-label" for="opay_new_order_id"><?php echo $entry_new_order_status; ?></label>
<div class="col-sm-10">
<select name="opay_new_order_id" id="opay_new_order_id" class="form-control">
<?php foreach ($order_statuses as $order_status): ?>
<?php if ($order_status['order_status_id'] == $opay_new_order_id): ?>
<option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
<?php else: ?>
<option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>

</div>
</div>

<div class="form-group">
<label class="col-sm-2 control-label" for="opay_finished_order_id"><?php echo $entry_finished_order_status; ?></label>
<div class="col-sm-10">
<select name="opay_finished_order_id" id="opay_finished_order_id" class="form-control">
<?php foreach ($order_statuses as $order_status): ?>
<?php if ($order_status['order_status_id'] == $opay_finished_order_id): ?>
<option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
<?php else: ?>
<option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>

</div>
</div>


<div class="form-group">
<label class="col-sm-2 control-label" for="opay_canceled_order_id"><?php echo $entry_canceled_order_status; ?></label>
<div class="col-sm-10">
<select name="opay_canceled_order_id" id="opay_canceled_order_id" class="form-control">
<?php foreach ($order_statuses as $order_status): ?>
<?php if ($order_status['order_status_id'] == $opay_canceled_order_id): ?>
<option value="<?php echo $order_status['order_status_id']; ?>" selected="selected"><?php echo $order_status['name']; ?></option>
<?php else: ?>
<option value="<?php echo $order_status['order_status_id']; ?>"><?php echo $order_status['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>

</div>
</div>


<div class="form-group">
<label class="col-sm-2 control-label" for="opay_geo_zone_id"><?php echo $entry_geo_zone; ?></label>
<div class="col-sm-10">
<select name="opay_geo_zone_id" id="opay_geo_zone_id" class="form-control">
<option value="0"><?php echo $text_all_zones; ?></option>
<?php foreach ($geo_zones as $geo_zone): ?>
<?php if ($geo_zone['geo_zone_id'] == $opay_geo_zone_id): ?>
<option value="<?php echo $geo_zone['geo_zone_id']; ?>" selected="selected"><?php echo $geo_zone['name']; ?></option>
<?php else: ?>
<option value="<?php echo $geo_zone['geo_zone_id']; ?>"><?php echo $geo_zone['name']; ?></option>
<?php endif; ?>
<?php endforeach; ?>
</select>

</div>
</div>


<div class="form-group">
<label class="col-sm-2 control-label" for="opay_status"><?php echo $entry_status; ?></label>
<div class="col-sm-10">
<select name="opay_status" id="opay_status" class="form-control">
<?php if (isset($opay_status) && $opay_status == false): ?>
<option value="1"><?php echo $text_enabled; ?></option>
<option value="0" selected="selected"><?php echo $text_disabled; ?></option>
<?php else: ?>
<option value="1" selected="selected"><?php echo $text_enabled; ?></option>
<option value="0"><?php echo $text_disabled; ?></option>
<?php endif; ?>
</select>

</div>
</div>

<div class="form-group">
<label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
<div class="col-sm-10">
<input type="text" name="opay_sort_order" value="<?php echo $opay_sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
</div>
</div>


</fieldset>
</form>
</div>
</div>
</div>
</div>

<script type="text/javascript">
jQuery(function($) {

    var previousStoreId
      , formChanged;

    var handleTestMode = function() {
        if ($('option:selected', this).val() == '1') {
            $('.testing_row').show();
        } else {
            $('.testing_row').hide();
        }
    }

    var handleFormChange = function() {
        formChanged = true;
    };

    var handleStoreIdFocus = function() {
        previousStoreId = $(this).val();
    };

    var handleStoreId = function() {
        var storeId     = $(this).val()
          , redirectUrl = updateQueryStringParameter(window.location.href, 'store_id', storeId);

        if (formChanged && !confirm("<?php echo $warn_unsaved_changes; ?>")) {
          $(this).val(previousStoreId);
          return;
        }
        window.location = redirectUrl;
    }

    var handleOpaySignatureType = function() {
        if ($('option:selected', this).val() == 'rsa') {
            $('.password_row').hide();
            $('.rsa_row').show();
        } else if ($('option:selected', this).val() == 'password') {
            $('.rsa_row').hide();
            $('.password_row').show();
        }
    };

    function updateQueryStringParameter(uri, key, value) {
        var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
        var separator = uri.indexOf('?') !== -1 ? "&" : "?";
        if (uri.match(re)) {
            return uri.replace(re, '$1' + key + "=" + value + '$2');
        }
        else {
            return uri + separator + key + "=" + value;
        }
    }

    // Attach handlers
    $('#opay_test_mode').change(handleTestMode);
    $('#opay_signature_type').change(handleOpaySignatureType);
    $('#store_id').on('focus', handleStoreIdFocus).change(handleStoreId);
    $('#form').change(handleFormChange);

});
</script>
<?php echo $footer; ?>
<?php
endif; // End of checking OpenCart versions
?>

